#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include user_scripts\mp_patches\dodge\edits;
init()
{
    precacheModel("soccer_ball");
	level.LoopTime = 0;
	level.Level_DBBuilt=0;
	level.map_setup_positive_connect=0;
	level.customFX = [];
	level.customFX["raygun_laser"]=				loadfx( "vfx/props/claymore_laser" );//Updated for HMW
	level.customFX["fire_smoke"]=				loadfx( "fx/fire/fire_smoke_trail_l");//Updated for HMW
	level.customFX["fire_ball"]=				loadfx( "vfx/trail/trail_fire_smoke_l");//Updated for HMW
	level.customFX["large_vehicle_explosion"]=	loadfx( "explosions/large_vehicle_explosion");//Updated for HMW
	level.customFX["force_field"]=				loadfx( "fx/fire/jet_afterburner_harrier" );//Updated for HMW
	level.customFX["red_blink_light"]=			loadfx( "vfx/lights/light_c4_blink");//Updated for HMW
	level.customFX["mine_flash"]=				loadfx( "vfx/explosion/frag_grenade_flash" );//Updated for HMW
	level.customFX["mine_explosion"]=			loadfx( "fx/explosions/artilleryexp_dirt_brown_2");//Updated for HMW
	level thread onPlayerConnect();
}
onPlayerConnect()
{
	for(;;)
	{
		level waittill( "connected", player );
		if (level.map_setup_positive!=1)
		{
			level.map_setup_positive=1;
			level.B = 0;
			self thread doFavelaEdit();
		}
		player thread onPlayerSpawned();
		if(level.map_setup_positive_connect!=1)
		{
		level.map_setup_positive_connect=1;
		level.map_setup_positive=0;
		}
	}
}
onPlayerSpawned()
{
	self endon( "disconnect" );
	for(;;)
	{
		self waittill( "spawned_player" );
		self thread setupPlayer();
	}
}
setupPlayer(){
	self.ballcount=0;
	self.Explode = 0;
	self.firstball = 0;
	self.KilledByHighBall=0;
	self _clearperks();
	self takeAllWeapons();
	self thread killstreaks();
	self thread BallAmountText();
	self thread AddForDeath();
	self thread runTeamSpawn();
	self thread Dewbs();
	//self thread testAng();
	//self.ballcount = 6;
	self.maxhealth = 10;
	self.health = self.maxhealth;
	self thread WaitForCountDOwn();
	//self thread TellLoop();
	//self thread MakeBalls((self.origin[0],self.origin[1],self.origin[2]-35),(0,0,0));
	wait 2;
	self freezeControlsWrapper(false);
}

testAng(){
	while(1){
		self iPrintLn(self getPlayerAngles());
		wait 1;
	}
}
AddForDeath()
{
self waittill("almost_dead");
self detach("soccer_ball","j_wrist_le");
for(r=0;r<self.ballcount;r++)
	{
	self thread MakeBallsForDead((self.origin[0],self.origin[1],self.origin[2]),(0,0,0));
	}
}
WaitForCountDOwn()
{
	self freezeControlsWrapper(false);
	self iPrintlnBold( "Play Ball!" );
	level notify("MakeBallsBOB");
}
TellLoop()
{
for(;;){
self iPrintLnBold( "player.ballcount" +self.ballcount);wait 0.3;}
}

doFavelaEdit()
{
	self endon("disconnect");
	
	self thread MakeBalls((-9913.58, -7958.59, -706.749),(0,0,0));
	self thread MakeBalls((-10080.62, -8265.67, -706.749),(0,0,0));
	self thread MakeBalls((-10152.41, -8397.04, -706.749),(0,0,0));
	
	self thread MakeBalls((-9981.37, -7957.4, -701.749),(0,0,0));
	self thread MakeBalls((-10076.4, -8132.26, -692.749),(0,0,0));
	self thread MakeBalls((-10215.77, -8385.16, -696.749),(0,0,0));
	
	//CreateGridsDB((-7694, -4476, -471),(-8730, -3840, -471),(0, -34, 0));
	level thread CreateWallsDB((-9939, -7941.46, -680.375),(-10231.26, -8478.65, -681.375));
	level thread CreateWallsDB((-9939, -7941.46, -625.375),(-10231.26, -8478.65, -624.375));
	
	level thread CreateWallsDB3((-9939, -7941.46, -726.375),(-10231.26, -8478.65, -725.375));
	
	level thread CreateWallsDB2((-10214.7, -7687.87, -660),(-9570.59, -8106.16, -661));
	level thread CreateWallsDB2((-9547.28, -8123.7, -660),(-9950.43, -8735.05, -661));
	level thread CreateWallsDB2((-9975.25, -8718.87, -660),(-10608.3, -8307.83, -661));
	level thread CreateWallsDB2((-10240.5, -7669.38, -660),(-10636.5, -8289.55, -661));

}
MakeBalls(pos,angles)
{
	level.B++;
	B=level.B;
	BallH[B]=spawn("script_model",pos);
	BallH[B] setModel("soccer_ball");
	BallH[B].angles=angles;
	trigger[B] = spawn( "trigger_radius", pos, 0, 75, 30 );
    trigger[B].angles = angles;
	trigger[B] thread CheckButtonBalls(pos,trigger[B]);
	trigger[B] waittill("BallTaken");
	trigger[B] delete();
	BallH[B] delete();
	
}
MakeBallsForDead(pos,angles)
{
	level.B++;
	B=level.B;
	BallH[B]=spawn("script_model",pos);
	BallH[B] setModel("soccer_ball");
	BallH[B].angles=angles;
	BallH[B] PhysicsLaunchServer((0,0,0),(0,0,0));
	wait 1;
	BallH[B] thread MakeBalls((BallH[B].origin[0],BallH[B].origin[1],BallH[B].origin[2]),(0,0,0));
	BallH[B] delete();
}
Dewbs()
{
self endon("death");
self endon("disconnect");
for(;;)
	{
	self.maxhealth = 10;
	self.health = self.maxhealth;
	wait 1;
	}
}
BallAmountText()
{
	if(isDefined(self.ballcount_text))
	{
		self.ballcount_text destroy();
	}
	self.ballcount_text = self createFontString("objective", 1.0);
	self.ballcount_text setPoint("BOTTOM", "LEFT", 70, 150);
	self.ballcount_text setText("Ball Count: "+self.ballcount);
	self.ballcount_text.HideWhenInMenu = true;
	self.ballcount_text.color = (25.5,25.5,3.6);
	self.ballcount_text.glowColor = (0.3,0.3,0.9);
	self.ballcount_text.glowAlpha = 1;
	self.ballcount_text.alpha = 1;
	self.explosive = "";
	while(isAlive(self))
		{
		self waittill("Ball_Change");
		self.ballcount_text setText("Ball Count: "+self.ballcount+"\n"+self.explosive);
		self.ballcount_text.fontscale=1.5;
		self.ballcount_text ChangeFontScaleOverTime(0.1);
		self.ballcount_text.fontscale=1.0;
		if(self.ballcount > 0 && !self.BallAttached)
			{
				self.BallAttached=1;
				self Attach("soccer_ball","j_wrist_le");
			}
		else if(self.ballcount < 1 && self.BallAttached)
			{
				self.BallAttached=0;
				self detach("soccer_ball","j_wrist_le");
			}
		}
	self.ballcount_text destroy();
}
runTeamSpawn()
{
	self endon("disconnect");
	while(!level.Level_DBBuilt)
		wait 0.025;
	if(self.team == "axis")
	{
		self.randomspawn = randomInt(4);
		self setPlayerAngles((4,150,0));
		if(self.randomspawn == 0)
		{
			self SetOrigin((-9953.38, -8597.12, -668.749));
		}
		else if(self.randomspawn == 1)
		{
			self SetOrigin((-9860.38, -8434.12, -668.749));
		}
		else if(self.randomspawn == 2)
		{
			self SetOrigin((-9781.38, -8299.12, -668.749));
		}
		else if(self.randomspawn == 3)
		{
			self SetOrigin((-9739.38, -8125.12, -668.749));
		}
	}
	else if(self.team == "allies")
	{
		self.randomspawn = randomInt(4);
		self setPlayerAngles((2,-31,0));
		if(self.randomspawn == 0)
		{
			self SetOrigin((-10216.03, -7846.08, -655.749));
		}
		else if(self.randomspawn == 1)
		{
			self SetOrigin((-10334.03, -7994.08, -655.749));
		}
		else if(self.randomspawn == 2)
		{
			self SetOrigin((-10424.03, -8111.08, -655.749));
		}
		else if(self.randomspawn == 3)
		{
			self SetOrigin((-10505.03, -8223.08, -655.749));
		}
		self takeAllWeapons();
		self thread killstreaks();
	}
}

CheckButtonBalls(pos,B)
{
self notify("NEWBALL2");
self endon("death");
self endon("disconnect");
self endon("NEWBALL2");
	while(1)
	{
		self waittill( "trigger", player );
		if(Distance(pos, player.origin) <= 75)
		{
			player setLowerMessage("activate", "Hold ^3[{+activate}]^7 To Pick Up Ball!" );
		}
		if(Distance(pos, Player.origin) >50)
		{
			player ClearLowerMessage("activate", 1);
		}
		if(Distance(pos, player.origin) <= 75 && player useButtonPressed())
		{
			wait 0.1;
			if(player useButtonPressed())
			{
				player ClearLowerMessage("activate", 1);
				player thread giveDeezNuts();
				B notify ("BallTaken");
			}
		}
	waitframe();
	}
}
giveDeezNuts()
{
	self notify("NEWBALL2");
	self endon("death");
	self endon("disconnect");
	self endon("NEWBALL2");
	self.ballcount++;
	self notify("Ball_Change");
	for(;;)
	{
		if(self.ballcount > 0 || !self.firstball)
		{
		self.firstball = 1;
		self setlethalweapon("iw9_throwknife_mp");
		self giveWeapon("iw9_throwknife_mp", 99, false);
		self setWeaponAmmoStock("iw9_throwknife_mp", 99);
		self switchToWeapon("iw9_throwknife_mp", 99, false);
		self waittill("grenade_fire", grenade, weaponName);
			if(weaponName == "iw9_throwknife_mp")
			{
				self setWeaponAmmoStock("iw9_throwknife_mp", 0);
				Ball = spawn("script_model", grenade.origin);
				Ball setModel("soccer_ball");
				Ball linkTo(grenade);
				self.ballcount--;
				self notify("Ball_Change");
				self.maxhealth = 10;
				self.health = self.maxhealth;
				grenade hide();
				self thread WaitToMake(grenade,Ball,self);
			}
		}
		waitframe();
	}
}
WaitToMake(grenade,Ball,attacker)
{
	self endon("death");
	self endon("disconnect");
	grenade waittill("missile_stuck");
	if(self.Explode == 1)
	{
		self.Explode=0;
		self.explosive = "";
		self notify("Ball_Change");
		earthquake(0.3,1,Ball.origin,1000);
		playfx(level.customFX["fire_smoke"],Ball.origin);
		RadiusDamage(Ball.origin,130,130,130,self);
	}
	else
	{
	Ball unlink();
	Ball solid();
	Ball PhysicsLaunchServer((0,0,0),(0,0,0));
	Ball.Notmade=1;
	Ball thread KillPlayersWithBall(attacker);
	while(Ball.Notmade)
	{
	Ball.HighOrigin = Ball.origin;
	wait 0.3;
	Ball.Canmake=Ball.HighOrigin[2]-Ball.origin[2];
	//iprintln(Ball.Canmake);
	if(Ball.Canmake < 1 && Ball.Canmake >= 0)
		{
		Ball.Notmade=0;
		break;
		}
	}
	self thread MakeBalls((Ball.origin[0],Ball.origin[1],Ball.origin[2]),Ball.angles);
	}
	Ball notify("Delete_Ball");
	Ball delete();
	grenade delete();

}
KillPlayersWithBall(attacker)
{
//self endon("Delete_Ball");
self.LowestHeight=0;
self.cankill=1;
for(;;)
	{
	if(isDefined(self.origin[2]))
		{
			//iPrintLnBold(self.origin[2]);
			//iPrintLn(self.LowestHeight);
			if(self.LowestHeight > self.origin[2] && self.cankill)
			{
				self thread KillPlayersWithBallF(attacker);
				self.LowestHeight = self.origin[2];
				//iPrintLn("KIll");
			}
			else
			{
				self.cankill=0;
				//iPrintLnBold("CAnt");
			}
		}
		wait 0.045;
	}
}
KillPlayersWithBallF(attacker)
{
	if(self.cankill)
	{
		foreach(player in level.players)
		{
		if(player IsTouching(self) && IsAlive(player) && !player.KilledByHighBall && player.team != attacker.team)
			{
			player.KilledByHighBall=1;
			player thread maps\mp\gametypes\_callbacksetup::CodeCallback_PlayerKilled(player, attacker, 999, "MOD_IMPACT", "gl_mp", (-0.2,-0.9,0.2), "none", 0, "2416");
			}
		}
	}
}
SpawnTriggerBall(Torigin, gotoOrigin, width, height, map_name)
{
	trig = spawn("trigger_radius", Torigin,0,width,height);
	trig.goto = gotoOrigin;
	trig thread waitfortrigBall(map_name);
	return trig;
}

waitfortrigBall(map_name)
{
	while(getdvar("mapname") == map_name)
	{
		self waittill("trigger",Ball);
		Ball setOrigin(self.goto);
		Ball iPrintlnBold("Anti-Glitch");
		wait 0.05;
	}
}
//Killstreaks

killstreaks()
{
	self endon ( "disconnect" );
	self endon ( "death" );
	for(;;)
	{
		self waittill( "killed_enemy" );
		switch(RandomInt(8))
		{
			case 0: self iPrintlnBold("^2Speed It Up!");
			self SetMoveSpeedScale(1.5);
			break;
			case 1: self iPrintlnBold("^2Your Invisable For 20 Sec!");
			self thread HideMe();
			break;
			case 2: self iPrintlnBold("^2Teleporter! ^5Time To Be Sneaky!");
			self notify ( "repeat" );
			self thread Teleporter();
			break;
			case 3: self iPrintlnBold("^2Explosive Ball!");
			self.explosive = "^1Explosive Ball!";
			self thread giveDeezNuts();
			wait 0.1;
			self.Explode = 1;
			wait 1.4;
			self iPrintlnBold("Press [{+attack}] To Use The ^2Explosive Ball!");
			break;
			case 4:
			break;
			case 5:
			break;
			case 6:
			break;
			case 7:
			break;
		}
	}
}
ExplodingBall()
{
	self thread ExplosiveBall();
	self takeAllWeapons();
	self _clearperks();
}
ExplosiveBall()
{
	self endon("disconnect");
	self endon("death");
	self giveWeapon("h1_fraggrenade_mp", 4, false);
	self switchToWeapon("h1_fraggrenade_mp", 4, false);
	self iPrintln("^1Explosive Ball Ready!");
	self waittill("grenade_fire", grenade, weaponName);
	if(weaponName == "h1_fraggrenade_mp")
		{
			Ball = spawn("script_model", grenade.origin);
			Ball setModel("soccer_ball");
			Ball linkTo(grenade);
			grenade hide();
			grenade waittill("explode");
			grenade delete();
			Ball delete();
			self setWeaponAmmoStock("h1_fraggrenade_mp", 0);
		}
}
HideMe()
{
	self hide();
	wait 20;
	self show();
	self iPrintlnBold("^1You Are No Long Invisable!");
}
Teleporter()
{
	self endon ( "disconnect" );
	self endon ( "death" );
	self endon ( "repeat" );
	self notifyOnPlayerCommand( "down", "+actionslot 2" );
	wait 2;
	self iPrintlnBold("^2Press [{+actionslot 2}] To Teleport!");
	self waittill("down");
	if(self.team == "allies")
	{
		self SetOrigin((-9953.38, -8597.12, -668.749));
	}
	else if(self.team == "axis")
	{
		self SetOrigin((-10216.03, -7846.08, -655.749));
	}
	wait 15;
	if(self.team == "axis")
	{
		self SetOrigin((-9953.38, -8597.12, -668.749));
	}
	else if(self.team == "allies")
	{
		self SetOrigin((-10216.03, -7846.08, -655.749));
	}
}


CreatDodgeText()
{
	if ( isdefined( self.Intro["Text"][0] ) ){self.Intro["Text"][2] destroy();}
	if ( isdefined( self.Intro["Text"][1] ) ){self.Intro["Text"][1] destroy();}
	if ( isdefined( self.Intro["Text"][2] ) ){self.Intro["Text"][0] destroy();}
	self endon("disconnect");
	wait 4.5;
	if(!isDefined(self.Intro["Text"])) self.Intro["Text"]=[];
	self.Intro["Text"][0]=createText("hudsmall",0.5,"Dodgeball",0,0,"CENTER","CENTER",undefined,undefined,2000,false,(25.5,25.5,3.6),1, 1,(0.3,0.3,0.9));
	self.Intro["Text"][1]=createText("hudsmall",0.5,"Version: v1.1",10,0,"CENTER","CENTER",undefined,undefined,2000,false,(25.5,25.5,3.6),1, 1,(0.3,0.3,0.9));
	self.Intro["Text"][2]=createText("hudsmall",0.5,"Made By FutureOps and ModdedModder",0,0,"CENTER","CENTER",undefined,undefined,2000,false,(25.5,25.5,3.6),1, 1,(0.3,0.3,0.9));
	self.Intro["Text"][0] ChangeFontScaleOverTime(2.0);
	self.Intro["Text"][0] elemMoveX(1.5,-210,190);
	self.Intro["Text"][0] ChangeFontScaleOverTime(2.0);
	self.Intro["Text"][0].fontscale=1.0;
	self.Intro["Text"][1] elemMoveX(1.3,-180,220);
	self.Intro["Text"][1] ChangeFontScaleOverTime(2.0);
	self.Intro["Text"][1].fontscale=1.0;
	self.Intro["Text"][2] elemMoveX(1.3,-150,250);
	self.Intro["Text"][2] ChangeFontScaleOverTime(2.0);
	self.Intro["Text"][2].fontscale=1.0;
	wait 1.9;
	self playLocalSound("mp_last_stand");
	wait 4.8;
	self.Intro["Text"][0] elemMoveX(0.9,-150,190);
	wait 0.4;
	self.Intro["Text"][0] elemMoveX(1.3,-1000,190);
	self.Intro["Text"][0] ChangeFontScaleOverTime(0.5);
	self.Intro["Text"][0].fontscale=0.5;
	self playLocalSound("mp_last_stand");
	wait 0.5;
	self.Intro["Text"][1] elemMoveX(0.9,-120,220);
	wait 0.4;
	self.Intro["Text"][1] elemMoveX(1.3,-1000,220);
	self.Intro["Text"][1] ChangeFontScaleOverTime(0.5);
	self.Intro["Text"][1].fontscale=0.5;
	self playLocalSound("mp_last_stand");
	wait 0.5;
	self.Intro["Text"][2] elemMoveX(0.9,-90,250);
	wait 0.4;
	self.Intro["Text"][2] elemMoveX(1.3,-1000,250);
	self.Intro["Text"][2] ChangeFontScaleOverTime(0.5);
	self.Intro["Text"][2].fontscale=0.5;
	self playLocalSound("mp_last_stand");
	wait 1;
	if ( isdefined( self.Intro["Text"][0] ) ){self.Intro["Text"][2] destroy();}
	if ( isdefined( self.Intro["Text"][1] ) ){self.Intro["Text"][1] destroy();}
	if ( isdefined( self.Intro["Text"][2] ) ){self.Intro["Text"][0] destroy();}
}
elemMoveX(time,input,output)
{
	self moveOverTime(time);
	self.x=input;
	self.y=output;
}
elemFade(time,newAlpha)
{
	self fadeOverTime(time);
	self.alpha=newAlpha;
}
createText(font,fontScale,text,x,y,horzAlign,vertAlign,alignX,alignY,sort,hideWhenInMenu,color,alpha,glowAlpha,glowColor)
{
	textElem=createFontString(font,fontScale);
	textElem setText(text);
	textElem.x=x;
	textElem.y=y;
	textElem.horzAlign=horzAlign;
	textElem.vertAlign=vertAlign;
	textElem.alignX=alignX;
	textElem.alignY=alignY;
	textElem.sort=sort;
	textElem.hideWhenInMenu=hideWhenInMenu;
	textElem.alpha=alpha;
	textElem.color=color;
	textElem.glowAlpha=glowAlpha;
	textElem.glowColor=glowColor;
	return textElem;
}